/*****************************************************************************/
/* File         srchdef.h                                                    */
/*                                                                           */
/* Purpose      Generic definitions for all collection routines              */
/*****************************************************************************/
#ifndef SRCHDEF_H
#define SRCHDEF_H

typedef enum srch_option_enum
{
  so_duplicates,
  so_no_duplicates,
  so_fifo,
  so_cache,
  so_sort,
  so_lifo,
  so_no_optimise,
  so_resize,
  so_no_resize,
  so_replace_deleted,
  so_hash,
  so_no_hash,
  so_postpone_write,
  so_no_postpone_write,
  so_delay_write,
  so_no_delay_write
} srch_option_t;

typedef unsigned long srch_flags_t;

/*****************************************************************************/
/* Common type definitions                                                   */
/*                                                                           */
/* comp_fn_t                 Type of the comparison function for sorts etc.  */
/* iterate_fn_t              Type of the walk function over collections etc  */
/* hash_hash_func_t          Hash function interface                         */
/*****************************************************************************/
#if defined(_NO_PROTO)
typedef int (*comp_fn_t)();
typedef int (*iterate_fn_t)();
#else
typedef int (*comp_fn_t)(void_ptr_t obj1, void_ptr_t obj2);
typedef int (*iterate_fn_t)(void_ptr_t obj1,void_ptr_t ptr);
#endif

#if !defined(HASH_FUNC_DEFINED)
#if defined(_NO_PROTO)
typedef unsigned (*hash_hash_func_t)();
#else
typedef unsigned (*hash_hash_func_t)(unsigned hash_size,void_ptr_t obj);
#endif
#define HASH_FUNC_DEFINED
#endif

#define SRCH_SET_FLAG(c,f) ((c)|=(f))
#define SRCH_CLR_FLAG(c,f) ((c)&=~(f))
#define SRCH_TST_FLAG(c,f) ((c)&(f))

#define COLL_SET_FLAG(c,f) (SRCH_SET_FLAG((c)->option_flags,(f)))
#define COLL_CLR_FLAG(c,f) (SRCH_CLR_FLAG((c)->option_flags,(f)))
#define COLL_TST_FLAG(c,f) (SRCH_TST_FLAG((c)->option_flags,(f)))

#define SF_INVALID_FLAG     (~(srch_flags_t)0)

#define SF_DUPLICATES_SHIFT (31)
#define SF_DUPLICATES_MASK  (((srch_flags_t)1)<<SF_DUPLICATES_SHIFT)

#define SF_OPTIMISE_BITS    (8)
#define SF_OPTIMISE_MASK    ((((srch_flags_t)1)<<SF_OPTIMISE_BITS)-1)
#define SF_OPTIMISE_SHIFT   (0)
#define SRCH_SET_OPTIMISE(c,f)\
  ((c)=((c)&~SF_OPTIMISE_MASK)|((f)<<SF_OPTIMISE_SHIFT))

#define SF_RESIZE_SHIFT     (30)
#define SF_RESIZE_MASK      (((srch_flags_t)1)<<SF_RESIZE_SHIFT)

#define SF_POSTPONE_WRITE_SHIFT (29)
#define SF_POSTPONE_WRITE_MASK  (((srch_flags_t)1)<<SF_POSTPONE_WRITE_SHIFT)

#define SF_DELAY_WRITE_SHIFT (29)
#define SF_DELAY_WRITE_MASK  (((srch_flags_t)1)<<SF_DELAY_WRITE_SHIFT)

#define SRCH_GET_OPTIMISE(c) (((c)&SF_OPTIMISE_MASK)>>SF_OPTIMISE_SHIFT)
#define COLL_GET_OPTIMISE(c) (SRCH_GET_OPTIMISE((c)->option_flags))

#define COLL_GET_DUPLICATES(c) (COLL_TST_FLAG(c,SF_DUPLICATES_MASK))
#define COLL_GET_RESIZE(c)     (COLL_TST_FLAG(c,SF_RESIZE_MASK))
#define COLL_GET_POSTPONE_WRITE(c) (COLL_TST_FLAG(c,SF_POSTPONE_WRITE_MASK))
#define COLL_GET_DELAY_WRITE(c) (COLL_TST_FLAG(c,SF_DELAY_WRITE_MASK))

#endif
